fit.ivrq <- function(d,exo,iv,y,tau){
# IV Quantile Regression
# d is the endogenous variable  (could also be spatial lag)
# exo are the exogenous variables, no intercept.
# iv is the instrument

# This should work only if these is a single d.
# I have previously tested it for the just identified case (i.e. one instrument, see also see example at the bottom)
# Also  should work for the overidentified case (more than 1 instrument, but have not tested it
# so the code may contain errors and unless tested one cannot be sure it gives the right results in this case

# It internally calculates the range of  coeff for d over which to do grid search.
# If you want  to declare this externally, just comment  the line declaring alpha and add alpha as external
# argument to the first function

X <- cbind(exo,1)
x <- cbind(d,X)
w <- cbind(iv,X)
ww <- t(w) %*% w
ww.inv <- ginv(as.matrix(ww))
wd <- t(w)%*%d
dhat <- w%*%ww.inv%*%wd
PSI <- cbind(dhat,X)
PSI1 <- cbind(d,X)
coef <- rq.fit(PSI,y,tau=tau)$coef
resid <- y - PSI1%*%coef
mu1 <- mean(resid)
sigma1 <- var(resid)
c <- ((1-tau)*tau)/(dnorm(qnorm(tau,mu1,sqrt(sigma1)),mu1,sqrt(sigma1))^2)
PSIinv <- diag(length(coef))
PSIinv <- backsolve(qr(x)$qr[1:length(coef), 1:length(coef)], PSIinv)
PSIinv <- PSIinv %*% t(PSIinv)
vc1 <- c*PSIinv
std <- sqrt((length(y)/100)*diag(vc1))
alpha <- seq(coef[1]-2*std[1],coef[1]+2*std[1],by=std[1]/20)
z <- cbind(dhat,X)
betas <- matrix(NA,dim(z)[2],length(alpha))
g <- matrix(NA,length(alpha),1)
for (i in 1:length(alpha)){
ya <- y - alpha[i]*d
betas[,i] <- rq.fit(z,ya,tau=tau)$coef
g[i,] <- max(svd(betas[1:dim(dhat)[2],i])$d)}
I <- which.min(g[,1])
param1 <- alpha[I]
est1 <- betas[(dim(dhat)[2]+1):dim(z)[2],I]
c(param1,est1)
}


se.ivrq <- function(bhat,d,exo,iv,y,tau){
n=length(y)
X <- cbind(exo,1)
S0 <- cbind(iv,X)
D <- cbind(d,X)
k=dim(D)[2]
vc <- matrix(0,k,k)
S <- (1/n)*t(S0)%*%S0
resid <- y - D%*%bhat
h <- c(1.364 * ((2*sqrt(pi))^(-1/5))*sqrt(var(resid))*(n^(-1/5)))
J = (1/(n*h))*t(c(dnorm(resid/h)) %o% c(rep(1,dim(D)[2])) * D)%*%S0
vc = (1/n)*(tau-tau^2)*ginv(as.matrix(J))%*%S%*%ginv(as.matrix(J))
rbind(bhat,(sqrt(diag(vc))))
}




